config.widgets.module('checkbox',
    [],
    () => {
        return {
            vue: true,
            name: 'gx-config-checkbox',
            template: '#config-checkbox',
            props: {
                label: {
                    required: true,
                    type: String
                },
                defaultValue: {
                    type: Boolean | String,
                }
            },
            data() {
                return {
                    input: typeof this.defaultValue === 'string' ? this.defaultValue !== '' : this.defaultValue
                }
            },
            watch: {
                input(val) {
                    this.$emit('input', val);
                }
            },
            methods: {
                getPhrase(title) {
                    const phraseSection = title.split('.');
                    const section = phraseSection[0];
                    const phrase = phraseSection[1];

                    return jse.core.lang.translate(phrase, section);
                }
            },
            init: done => done()
        }
    });